/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.auiml.databeans.sfp.data;

import com.ibm.hsc.auiml.databeans.sfp.data.CSPFRU;
import com.ibm.hsc.auiml.databeans.sfp.data.StructuredData;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Date;
import java.util.StringTokenizer;

public class CSPError
implements Serializable {
    private String timeStamp = null;
    private String errorCode = null;
    private String errorText = null;
    private String locCodes = null;
    private String intFRUIds = null;
    private String priorities = null;
    private String logDetail = null;
    private String opPanelCodeString = null;
    private CSPFRU[] cspFRUs = null;
    private String[] opPanelCodes = null;

    public CSPError(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        this.timeStamp = string;
        this.errorCode = string2;
        this.errorText = string3;
        this.locCodes = string4;
        this.intFRUIds = string5;
        this.priorities = string6;
        this.logDetail = string7;
        this.opPanelCodeString = string8;
    }

    public String getTimeStamp() {
        return this.timeStamp;
    }

    public Date getTimeStampDate() {
        try {
            return StructuredData.TS_FORMATTER.parse(this.timeStamp);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getErrorText() {
        return this.errorText;
    }

    public String getLogDetail() {
        return this.logDetail;
    }

    public synchronized CSPFRU[] getCSPFRUs() {
        if (this.cspFRUs == null) {
            this.parseCSPFRUs();
        }
        return this.cspFRUs;
    }

    public synchronized String[] getOpPanelCodes() {
        if (this.opPanelCodes == null) {
            this.parseOpPanelCodes();
        }
        return this.opPanelCodes;
    }

    private void parseCSPFRUs() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.locCodes, ",", false);
        StringTokenizer stringTokenizer2 = new StringTokenizer(this.intFRUIds, ",", false);
        StringTokenizer stringTokenizer3 = new StringTokenizer(this.priorities, ",", false);
        int n = Math.max(stringTokenizer.countTokens(), stringTokenizer2.countTokens());
        n = Math.max(n, stringTokenizer3.countTokens());
        this.cspFRUs = new CSPFRU[n];
        int n2 = 0;
        while (n2 < n) {
            String string = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "";
            String string2 = stringTokenizer2.hasMoreTokens() ? stringTokenizer2.nextToken() : "";
            String string3 = stringTokenizer3.hasMoreTokens() ? stringTokenizer3.nextToken() : "";
            this.cspFRUs[n2] = new CSPFRU(string, string2, string3);
            ++n2;
        }
    }

    private void parseOpPanelCodes() {
        if (this.opPanelCodeString == null || this.opPanelCodeString.length() < 6) {
            this.opPanelCodes = new String[0];
        } else {
            int n = 0;
            try {
                n = Integer.parseInt(this.opPanelCodeString.substring(0, 3));
                if (n < 0) {
                    n = 0;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            int n2 = 0;
            try {
                n2 = Integer.parseInt(this.opPanelCodeString.substring(3, 6));
                if (n2 < 0) {
                    n2 = 0;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            String string = this.opPanelCodeString.substring(6);
            this.opPanelCodes = new String[n2];
            int n3 = n2 - 1;
            while (n3 >= 0) {
                String string2 = null;
                if (n <= string.length()) {
                    string2 = string.substring(0, n);
                    string = string.substring(n);
                } else {
                    string2 = string;
                    string = "";
                }
                if (string2.length() > 4) {
                    string2 = string2.substring(0, 4) + " " + string2.substring(4);
                }
                this.opPanelCodes[n3] = string2;
                --n3;
            }
        }
    }
}

